/**
 * Timer class.
 */
class UITimer {
	/**
	 * Method used to implement a simple callback delay.
	 *
	 * @param 	function  callback  The function to invoke.
	 * @param 	integer   ms        The milliseconds to wait.
	 * @param 	mixed     id        An optional callback identifier.
	 *
	 * @return 	void
	 */
	static delay(callback, ms, id) {
		if (typeof id === 'undefined') {
			id = '__default';
		}

		// in case of existing timeout, clear it
		if (UITimer.timeout.hasOwnProperty(id)) {
			clearTimeout(UITimer.timeout[id]);
		}

		// start new timeout
		UITimer.timeout[id] = setTimeout(() => {
			// invoke callback
			callback();
			// delete timer from the list
			delete UITimer.timeout[id];
		}, ms);
	}
}

/**
 * Timeouts pool.
 *
 * @var object
 */
UITimer.timeout = {};

// export for external usage
module.exports = UITimer;
